#include <Python.h>
#include <stdbool.h>
#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
#include "LDAhid.h"
#define FALSE 0
#define TRUE !FALSE
#define VERBOSE 0
#define WRAPPERVERSION "0.2"

// A module that takes no arguments
static PyObject* LDA_module_print_hello_world(PyObject *self, PyObject *args)
{
  printf("LDA cpy: Hello World\r\n");
  Py_RETURN_NONE;
}

/* This is the Vaunix-specific stuff. */
//void fnLDA_Init(void);
// A module that takes no arguments
static PyObject* LDA_module_fnLDA_Init(PyObject *self, PyObject *args)
{
  fnLDA_Init();
  Py_RETURN_NONE;
}

//void fnLDA_SetTestMode(bool testmode);
static PyObject* LDA_module_fnLDA_SetTestMode(PyObject *self, PyObject *args)
{
  int n;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetTestMode cpy: arg 1 is devid %d\r\n", devid);
#endif
      fnLDA_SetTestMode(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetTestMode expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetTestMode expects one argument");
      return NULL;
  }
  Py_RETURN_NONE;
}

//int fnLDA_GetNumDevices();
// A module that takes no arguments
static PyObject* LDA_module_fnLDA_GetNumDevices(PyObject *self, PyObject *args)
{
  int n;
  n = fnLDA_GetNumDevices();
  return PyLong_FromLong(n);
}

//int fnLDA_GetDevInfo(DEVID *ActiveDevices)
static PyObject* LDA_module_fnLDA_GetDevInfo(PyObject *self, PyObject *args)
{
  int i, n, numElements, result;
  PyObject *listObj, *numObj;
  unsigned int cActiveDevices[MAXDEVICES];

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) {
    /* argument 1 should be an list of integers */
    listObj = PyTuple_GetItem(args, 0);
    /* get the number of lines passed to us */
    numElements = PyList_Size(listObj);

    /* should raise an error here. */
    if (numElements < 0)   return NULL; /* Not a list */
    if (numElements > MAXDEVICES) numElements = MAXDEVICES; /* Limit the number of devices to match the MAXDEVICES */
#if VERBOSE
    printf("The list has %d elements\r\n", numElements);
#endif
    
    for (i=0; i<numElements; i++) {
      numObj = PyList_GetItem(listObj, i);
      cActiveDevices[i] = PyLong_AsUnsignedLong(PyNumber_Long(numObj));
#if VERBOSE
      printf("Before, element %d is %d\r\n", i, cActiveDevices[i]);
#endif
    }
    result = fnLDA_GetDevInfo(cActiveDevices);
    
    for (i=0; i<numElements; i++) {
      PyList_SetItem(listObj, i, Py_BuildValue("i", cActiveDevices[i]));
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetDevInfo expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLDA_GetModelName(DEVID deviceID, char *ModelName);
static PyObject* LDA_module_fnLDA_GetModelName(PyObject *self, PyObject *args)
{
  int n;
  unsigned int devid;
  PyObject *temp_p;
  char ModelName[64];

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetModelName cpy: arg 1  is devid %d\r\n", devid);
#endif
      //result = fnLDA_GetModelName(i, ModelName);
      fnLDA_GetModelName(devid, ModelName);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetModelName expects one argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetModelName expects one argument");
      return NULL;
  }
  return PyBytes_FromString(ModelName);
}


//int fnLDA_InitDevice(DEVID deviceID);
static PyObject* LDA_module_fnLDA_InitDevice(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("InitDevice cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_InitDevice(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_InitDevice expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_InitDevice expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLDA_CloseDevice(DEVID deviceID);
static PyObject* LDA_module_fnLDA_CloseDevice(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("CloseDevice cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_CloseDevice(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_CloseDevice expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_CloseDevice expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//int fnLDA_GetSerialNumber(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetSerialNumber(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetSerialNumber cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetSerialNumber(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetSerialNumber expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetSerialNumber expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//LVSTATUS fnLDA_SetChannel(DEVID deviceID, int channel);
static PyObject* LDA_module_fnLDA_SetChannel(PyObject *self, PyObject *args)
{
  int n, result, channel;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetFrequency cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetChannel expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      channel = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is channel %d\r\n", channel);
#endif
      result = fnLDA_SetChannel(devid, channel);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetChannel expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetChannel expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLDA_SetWorkingFrequency(DEVID deviceID, int frequency);
static PyObject* LDA_module_fnLDA_SetWorkingFrequency(PyObject *self, PyObject *args)
{
  int n, result, frequency;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("SetFrequency cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetWorkingFrequency expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      frequency = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is frequency %d\r\n", frequency);
#endif
      result = fnLDA_SetWorkingFrequency(devid, frequency);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetWorkingFrequency expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetWorkingFrequency expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetWorkingFrequency(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetWorkingFrequency(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("GetFrequency cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetWorkingFrequency(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetWorkingFrequency expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetWorkingFrequency expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetMinWorkingFrequency(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetMinWorkingFrequency(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Minimum Frequency cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetMinWorkingFrequency(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetMinWorkingFrequency expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetMinWorkingFrequency expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetWorkingFrequency(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetMaxWorkingFrequency(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Max Frequency cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetMaxWorkingFrequency(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetMaxWorkingFrequency expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetMaxWorkingFrequency expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetAttenuation(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetAttenuation(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Attenuation cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetAttenuation(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetAttenuation expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetAttenuation expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetRampStart(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetRampStart(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Ramp Start cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetRampStart(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetRampStart expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetRampStart expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetRampEnd(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetRampEnd(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Ramp End cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetRampEnd(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetRampEnd expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetRampEnd expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetDwellTime(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetDwellTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Dwell time cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetDwellTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetDwellTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetDwellTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetDwellTimeTwo(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetDwellTimeTwo(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Dwell time two cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetDwellTimeTwo(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetDwellTimeTwo expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetDwellTimeTwo expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetIdleTime(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetIdleTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Idle time cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetIdleTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetIdleTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetIdleTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetHoldTime(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetHoldTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get hold time cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetHoldTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetHoldTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetHoldTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetAttenuationStep(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetAttenuationStep(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Attenuation step cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetAttenuationStep(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetAttenuationStep expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetAttenuationStep expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetAttenuationStepTwo(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetAttenuationStepTwo(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Attenuation step two cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetAttenuationStepTwo(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetAttenuationStepTwo expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetAttenuationStepTwo expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetRF_On(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetRF_On(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get RF On cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetRF_On(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetRF_On expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetRF_On expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetProfileElement(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetProfileElement(PyObject *self, PyObject *args)
{
  int n, result, index;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
	  temp_p = PyTuple_GetItem(args, 1);
	  index = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Profile Element cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetProfileElement(devid, index);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileElement expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileElement expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}
//int fnLDA_GetProfileCount(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetProfileCount(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Profile count cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetProfileCount(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileCount expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileCount expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetProfileDwellTime(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetProfileDwellTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Profile dwell time cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetProfileDwellTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileDwellTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileDwellTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetProfileIdleTime(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetProfileIdleTime(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Profile idle time cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetProfileIdleTime(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileIdleTime expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileIdleTime expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetProfileIndex(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetProfileIndex(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Profile index cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetProfileIndex(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileIndex expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileIndex expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetMaxAttenuation(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetMaxAttenuation(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get max attenuation cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetMaxAttenuation(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetMaxAttenuation expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetMaxAttenuation expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetMinAttenuation(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetMinAttenuation(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get min attenuation cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetMinAttenuation(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetMinAttenuation expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetMinAttenuation expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetMinAttenStep(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetMinAttenStep(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get min attenuation step cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetMinAttenStep(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetMinAttenStep expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetMinAttenStep expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetFeatures(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetFeatures(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get features cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetFeatures(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetFeatures expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetFeatures expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetNumChannels(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetNumChannels(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get Number of Channels cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetNumChannels(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetNumChannels expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetNumChannels expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//int fnLDA_GetProfileMaxLength(DEVID deviceID);
static PyObject* LDA_module_fnLDA_GetProfileMaxLength(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Get profile max length cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_GetProfileMaxLength(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileMaxLength expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_GetProfileMaxLength expects one argument");
      return NULL;
  }
  return PyLong_FromLong(result);
}


//LVSTATUS fnLDA_SetAttenuation(DEVID deviceID, int attenuation);
static PyObject* LDA_module_fnLDA_SetAttenuation(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set attenuation cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuation expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is attenuation %d\r\n", data);
#endif
      result = fnLDA_SetAttenuation(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuation expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuation expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLDA_SetAttenuationQ(DEVID deviceID, int attenuation, int channel)
static PyObject* LDA_module_fnLDA_SetAttenuationQ(PyObject *self, PyObject *args)
{
  int n, result, data, channel;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (3 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set attenuation cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuationQ expects three integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
	  temp_p = PyTuple_GetItem(args, 2);
	  channel = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is attenuation %d\r\n", data);
	  printf("arg 3 is channel %d\r\n", channel);
#endif
      result = fnLDA_SetAttenuationQ(devid, data, channel);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuationQ expects three integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuationQ expects three arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLDA_SetRampStart(DEVID deviceID, int rampstart);
static PyObject* LDA_module_fnLDA_SetRampStart(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set rampstart cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampStart expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is rampstart attenuation %d\r\n", data);
#endif
      result = fnLDA_SetRampStart(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampStart expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampStart expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLDA_SetRampEnd(DEVID deviceID, int rampstop);
static PyObject* LDA_module_fnLDA_SetRampEnd(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set rampend cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampEnd expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is rampend attenuation %d\r\n", data);
#endif
      result = fnLDA_SetRampEnd(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampEnd expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampEnd expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLDA_SetAttenuationStep(DEVID deviceID, int rampstop);
static PyObject* LDA_module_fnLDA_SetAttenuationStep(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set attenuation step cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuationStep expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is attenuation step %d\r\n", data);
#endif
      result = fnLDA_SetAttenuationStep(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuationStep expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuationStep expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLDA_SetAttenuationStepTwo(DEVID deviceID, int attenuationstep2);
static PyObject* LDA_module_fnLDA_SetAttenuationStepTwo(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set bi-directional attenuation step cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuationStepTwo expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is bi-directional attenuation step %d\r\n", data);
#endif
      result = fnLDA_SetAttenuationStepTwo(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuationStepTwo expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetAttenuationStepTwo expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLDA_SetDwellTime(DEVID deviceID, int dwelltime);
static PyObject* LDA_module_fnLDA_SetDwellTime(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set dwell time cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetDwellTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is dwell time %d\r\n", data);
#endif
      result = fnLDA_SetDwellTime(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetDwellTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetDwellTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SetIdleTime(DEVID deviceID, int idletime);
static PyObject* LDA_module_fnLDA_SetIdleTime(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set idle time two cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetIdleTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is idle time two  %d\r\n", data);
#endif
      result = fnLDA_SetIdleTime(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetIdleTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetIdleTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SetHoldTime(DEVID deviceID, int holdtime);
static PyObject* LDA_module_fnLDA_SetHoldTime(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set hold time cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetHoldTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is hold time %d\r\n", data);
#endif
      result = fnLDA_SetHoldTime(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetHoldTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetHoldTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SetDwellTimeTwo(DEVID deviceID, int dwelltime2);
static PyObject* LDA_module_fnLDA_SetDwellTimeTwo(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set dwell time two cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetDwellTimeTwo expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is dwell time two  %d\r\n", data);
#endif
      result = fnLDA_SetDwellTimeTwo(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetDwellTimeTwo expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetDwellTimeTwo expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SetProfileElement(DEVID deviceID, int index, int attenuation);
static PyObject* LDA_module_fnLDA_SetProfileElement(PyObject *self, PyObject *args)
{
  int n, result, data, attn;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (3 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile element cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileElement expects three integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
	  temp_p = PyTuple_GetItem(args, 2);
	  attn = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is index %d\r\n", data);
	  printf("arg 3 is attn %d\r\n", attn);
#endif
      result = fnLDA_SetProfileElement(devid, data, attn);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileElement expects three integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileElement expects three arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SetProfileCount(DEVID deviceID, int profilecount);
static PyObject* LDA_module_fnLDA_SetProfileCount(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile count cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileCountfnLDA_SetAttenuationQ expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is profile count %d\r\n", data);
#endif
      result = fnLDA_SetProfileCount(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileCount expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileCount expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SetProfileIdleTime(DEVID deviceID, int idletime);
static PyObject* LDA_module_fnLDA_SetProfileIdleTime(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile idle time cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileIdleTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is profile idle time %d\r\n", data);
#endif
      result = fnLDA_SetProfileIdleTime(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileIdleTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileIdleTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SetProfileDwellTime(DEVID deviceID, int dwelltime);
static PyObject* LDA_module_fnLDA_SetProfileDwellTime(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile dwell time cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileDwellTime expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is profile dwell time %d\r\n", data);
#endif
      result = fnLDA_SetProfileDwellTime(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileDwellTime expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetProfileDwellTime expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_StartProfile(DEVID deviceID, int mode);
static PyObject* LDA_module_fnLDA_StartProfile(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set profile mode cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_StartProfile expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is profile mode %d\r\n", data);
#endif
      result = fnLDA_StartProfile(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_StartProfile expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_StartProfile expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SetRFOn(DEVID deviceID, bool on);
static PyObject* LDA_module_fnLDA_SetRFOn(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set rf state cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRFOn expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is rf state %d\r\n", data);
#endif
      result = fnLDA_SetRFOn(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRFOn expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRFOn expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SetRampDirection(DEVID deviceID, bool up);
static PyObject* LDA_module_fnLDA_SetRampDirection(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set ramp direction cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampDirection expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is ramp direction %d\r\n", data);
#endif
      result = fnLDA_SetRampDirection(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampDirection expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampDirection expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SetRampMode(DEVID deviceID, bool mode;
static PyObject* LDA_module_fnLDA_SetRampMode(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set ramp mode cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampMode expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is ramp mode %d\r\n", data);
#endif
      result = fnLDA_SetRampMode(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampMode expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampMode expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLDA_SetRampBidirectional(DEVID deviceID, bool bidir_enable)
static PyObject* LDA_module_fnLDA_SetRampBidirectional(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set ramp bi-drectional cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampBidirectional expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is ramp bi-drectional %d\r\n", data);
#endif
      result = fnLDA_SetRampBidirectional(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampBidirectional expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SetRampBidirectional expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//LVSTATUS fnLDA_StartRamp(DEVID deviceID, bool go)
static PyObject* LDA_module_fnLDA_StartRamp(PyObject *self, PyObject *args)
{
  int n, result, data;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (2 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set ramp control cpy: arg 1 is devid %d\r\n", devid);
#endif
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_StartRamp expects two integer arguments");
      return NULL;
    }
    temp_p = PyTuple_GetItem(args, 1);
    if (1 == PyNumber_Check(temp_p)) {
      data = PyLong_AsLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("arg 2 is ramp control %d\r\n", data);
#endif
      result = fnLDA_StartRamp(devid, data);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_StartRamp expects two integer arguments");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_StartRamp expects two arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

// LVSTATUS fnLDA_SaveSettings(DEVID deviceID)
static PyObject* LDA_module_fnLDA_SaveSettings(PyObject *self, PyObject *args)
{
  int n, result;
  unsigned int devid;
  PyObject *temp_p;

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      devid = PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("Set save settings cpy: arg 1 is devid %d\r\n", devid);
#endif
      result = fnLDA_SaveSettings(devid);
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SaveSettings expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_SaveSettings expects one arguments");
      return NULL;
  }
  return PyLong_FromLong(result);
}

//char* fnLDA_perror(LVSTATUS status);
static PyObject* LDA_module_fnLDA_perror(PyObject *self, PyObject *args)
{
  unsigned int i, n;
  PyObject *temp_p;
  char errorstring[64];

  n = PyTuple_Size(args);
#if VERBOSE
  printf("I think you sent me %d args?\r\n", n);
#endif
  if (1 == n) { 
    temp_p = PyTuple_GetItem(args, 0);
    if (1 == PyNumber_Check(temp_p)) {
      i = 0xFFFFFFFF & PyLong_AsUnsignedLong(PyNumber_Long(temp_p));
#if VERBOSE
      printf("perror cpy: arg 1 is %x\r\n", i);
#endif
      sprintf(errorstring,"%s",fnLDA_perror(i));
    } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_fnLDA_perror expects one integer argument");
      return NULL;
    }
  } else {
      PyErr_SetString(PyExc_ValueError, "LDA_module.fnLDA_fnLDA_perror expects one argument");
      return NULL;
  }
  return PyBytes_FromString(errorstring);
}

//char* fnLDA_LibVersion(void);
static PyObject* LDA_module_fnLDA_LibVersion(PyObject *self, PyObject *args)
{
  char errorstring[64];

  sprintf(errorstring,"%s",fnLDA_LibVersion());
  return PyBytes_FromString(errorstring);
}

static PyObject* LDA_module_WrapperVersion(PyObject *self, PyObject *args)
{
  return PyBytes_FromString(WRAPPERVERSION);
}
//Method definition object for this extension, these argumens mean:
//ml_name: The name of the method
//ml_meth: Function pointer to the method implementation
//ml_flags: Flags indicating special features of this method, such as
//          accepting arguments, accepting keyword arguments, being a
//          class method, or being a static method of a class.
//ml_doc:  Contents of this method's docstring
static PyMethodDef LDA_module_methods[] = { 
    {   
        "print_hello_world",
        LDA_module_print_hello_world,
        METH_NOARGS,
        "Print 'hello world' from a method defined in a C extension."
    },  
    {   
        "fnLDA_Init",
        LDA_module_fnLDA_Init,
        METH_NOARGS,
        "Set up the LDA device"
    },  
    {   
        "fnLDA_SetTestMode",
        LDA_module_fnLDA_SetTestMode,
        METH_VARARGS,
        "Set test mode if desired"
    },  
    {   
        "fnLDA_GetNumDevices",
        LDA_module_fnLDA_GetNumDevices,
        METH_NOARGS,
        "Return the number of LDA devices"
    },  
    {   
        "fnLDA_GetDevInfo",
        LDA_module_fnLDA_GetDevInfo,
        METH_VARARGS,
        "Returns a list of active devices"
    },  
    {   
        "fnLDA_GetModelName",
        LDA_module_fnLDA_GetModelName,
        METH_VARARGS,
        "Returns the name of an LDA model"
    },  
    {   
        "fnLDA_InitDevice",
        LDA_module_fnLDA_InitDevice,
        METH_VARARGS,
        "Initializes an LDA device"
    },  
    {   
        "fnLDA_CloseDevice",
        LDA_module_fnLDA_CloseDevice,
        METH_VARARGS,
        "Closes an LDA device"
    },  
    {   
        "fnLDA_GetSerialNumber",
        LDA_module_fnLDA_GetSerialNumber,
        METH_VARARGS,
        "Returns the serial of an LDA device"
    },  
    {   
        "fnLDA_SetChannel",
        LDA_module_fnLDA_SetChannel,
        METH_VARARGS,
        "Sets the Channel on an LDA device"
    },  
    {   
        "fnLDA_SetWorkingFrequency",
        LDA_module_fnLDA_SetWorkingFrequency,
        METH_VARARGS,
        "Sets the Working Frequency on an LDA device"
    },  
    {   
        "fnLDA_GetWorkingFrequency",
        LDA_module_fnLDA_GetWorkingFrequency,
        METH_VARARGS,
        "Returns the current working frequency"
    },  
    {   
        "fnLDA_GetMinWorkingFrequency",
        LDA_module_fnLDA_GetMinWorkingFrequency,
        METH_VARARGS,
        "Returns the minimum working frequency"
    },
    {   
        "fnLDA_GetMaxWorkingFrequency",
        LDA_module_fnLDA_GetMaxWorkingFrequency,
        METH_VARARGS,
        "Returns the maximum working frequency"
    },
    {   
        "fnLDA_GetAttenuation",
        LDA_module_fnLDA_GetAttenuation,
        METH_VARARGS,
        "Returns the current attenuation"
    }, 
    {   
        "fnLDA_GetRampStart",
        LDA_module_fnLDA_GetRampStart,
        METH_VARARGS,
        "Returns the ramp start attenuation data"
    }, 
    {   
        "fnLDA_GetRampEnd",
        LDA_module_fnLDA_GetRampEnd,
        METH_VARARGS,
        "Returns the ramp end attenuation data"
    }, 
    {   
        "fnLDA_GetDwellTime",
        LDA_module_fnLDA_GetDwellTime,
        METH_VARARGS,
        "Returns the dwell time data"
    }, 
    {   
        "fnLDA_GetDwellTimeTwo",
        LDA_module_fnLDA_GetDwellTimeTwo,
        METH_VARARGS,
        "Returns the dwell time two data"
    }, 
    {   
        "fnLDA_GetIdleTime",
        LDA_module_fnLDA_GetIdleTime,
        METH_VARARGS,
        "Returns the idle time"
    }, 
    {   
        "fnLDA_GetHoldTime",
        LDA_module_fnLDA_GetHoldTime,
        METH_VARARGS,
        "Returns the hold time"
    }, 
    {   
        "fnLDA_GetAttenuationStep",
        LDA_module_fnLDA_GetAttenuationStep,
        METH_VARARGS,
        "Returns the attenuation step size"
    }, 	
    {   
        "fnLDA_GetAttenuationStepTwo",
        LDA_module_fnLDA_GetAttenuationStepTwo,
        METH_VARARGS,
        "Returns the attenaution step size two"
    }, 
    {   
        "fnLDA_GetRF_On",
        LDA_module_fnLDA_GetRF_On,
        METH_VARARGS,
        "Returns the RF State"
    }, 
    {   
        "fnLDA_GetProfileElement",
        LDA_module_fnLDA_GetProfileElement,
        METH_VARARGS,
        "Returns the profile element of the index"
    }, 
    {   
        "fnLDA_GetProfileCount",
        LDA_module_fnLDA_GetProfileCount,
        METH_VARARGS,
        "Returns the profile count data"
    }, 
    {   
        "fnLDA_GetProfileDwellTime",
        LDA_module_fnLDA_GetProfileDwellTime,
        METH_VARARGS,
        "Returns the profile dwell time"
    }, 
    {   
        "fnLDA_GetProfileIdleTime",
        LDA_module_fnLDA_GetProfileIdleTime,
        METH_VARARGS,
        "Returns the profile idle time"
    }, 
    {   
        "fnLDA_GetProfileIndex",
        LDA_module_fnLDA_GetProfileIndex,
        METH_VARARGS,
        "Returns the profile index"
    }, 
    {   
        "fnLDA_GetMaxAttenuation",
        LDA_module_fnLDA_GetMaxAttenuation,
        METH_VARARGS,
        "Returns the max attenuation"
    }, 
    {   
        "fnLDA_GetMinAttenuation",
        LDA_module_fnLDA_GetMinAttenuation,
        METH_VARARGS,
        "Returns the minimum attenuation"
    }, 
    {   
        "fnLDA_GetMinAttenStep",
        LDA_module_fnLDA_GetMinAttenStep,
        METH_VARARGS,
        "Returns the minimum attenuation step size"
    }, 
    {   
        "fnLDA_GetFeatures",
        LDA_module_fnLDA_GetFeatures,
        METH_VARARGS,
        "Returns the current features"
    }, 
    {   
        "fnLDA_GetNumChannels",
        LDA_module_fnLDA_GetNumChannels,
        METH_VARARGS,
        "Returns the number of channels"
    }, 
    {   
        "fnLDA_GetProfileMaxLength",
        LDA_module_fnLDA_GetProfileMaxLength,
        METH_VARARGS,
        "Returns the profile max length"
    }, 
    {   
        "fnLDA_SetAttenuation",
        LDA_module_fnLDA_SetAttenuation,
        METH_VARARGS,
        "Sets the attenuation to an LDA device"
    },  
    {   
        "fnLDA_SetAttenuationQ",
        LDA_module_fnLDA_SetAttenuationQ,
        METH_VARARGS,
        "Sets the attenuation of channel to an LDA device"
    },  
    {   
        "fnLDA_SetRampStart",
        LDA_module_fnLDA_SetRampStart,
        METH_VARARGS,
        "Sets the ramp start attenuation to an LDA device"
    },  
    {   
        "fnLDA_SetRampEnd",
        LDA_module_fnLDA_SetRampEnd,
        METH_VARARGS,
        "Sets the ramp stop attenuation to an LDA device"
    },  
    {   
        "fnLDA_SetAttenuationStep",
        LDA_module_fnLDA_SetAttenuationStep,
        METH_VARARGS,
        "Sets the attenuator step size to an LDA device"
    },  
    {   
        "fnLDA_SetAttenuationStepTwo",
        LDA_module_fnLDA_SetAttenuationStepTwo,
        METH_VARARGS,
        "Sets the bi0drectional attenuator step size to an LDA device"
    },  
    {   
        "fnLDA_SetDwellTime",
        LDA_module_fnLDA_SetDwellTime,
        METH_VARARGS,
        "Sets the dwell time to on an LDA device"
    }, 
    {   
        "fnLDA_SetDwellTimeTwo",
        LDA_module_fnLDA_SetDwellTimeTwo,
        METH_VARARGS,
        "Sets the bi-directional dwell time to an LDA device"
    },  
    {   
        "fnLDA_SetIdleTime",
        LDA_module_fnLDA_SetIdleTime,
        METH_VARARGS,
        "Sets the idle time to an LDA device"
    },  
    {   
        "fnLDA_SetHoldTime",
        LDA_module_fnLDA_SetHoldTime,
        METH_VARARGS,
        "Sets the hold time to an LDA device"
    },  
    {   
        "fnLDA_SetProfileElement",
        LDA_module_fnLDA_SetProfileElement,
        METH_VARARGS,
        "Sets the profile element to an LDA device"
    },  
    {   
        "fnLDA_SetProfileCount",
        LDA_module_fnLDA_SetProfileCount,
        METH_VARARGS,
        "Sets the profile count to an LDA device"
    },  
    {   
        "fnLDA_SetProfileIdleTime",
        LDA_module_fnLDA_SetProfileIdleTime,
        METH_VARARGS,
        "Sets the profile idle time to an LDA device"
    },  
    {   
        "fnLDA_SetProfileDwellTime",
        LDA_module_fnLDA_SetProfileDwellTime,
        METH_VARARGS,
        "Sets the profile dwell time to an LDA device"
    },  
    {   
        "fnLDA_StartProfile",
        LDA_module_fnLDA_StartProfile,
        METH_VARARGS,
        "Sets the profile mode to an LDA device"
    },
    {   
        "fnLDA_SetRFOn",
        LDA_module_fnLDA_SetRFOn,
        METH_VARARGS,
        "Sets the rf state to an LDA device"
    },  
    {   
        "fnLDA_SetRampDirection",
        LDA_module_fnLDA_SetRampDirection,
        METH_VARARGS,
        "Sets the ramp direction to an LDA device"
    },  
    {   
        "fnLDA_SetRampMode",
        LDA_module_fnLDA_SetRampMode,
        METH_VARARGS,
        "Sets the ramp mode to an LDA device"
    },  
    {   
        "fnLDA_SetRampBidirectional",
        LDA_module_fnLDA_SetRampBidirectional,
        METH_VARARGS,
        "Sets the bi-directional ramp mode to an LDA device"
    },  
    {   
        "fnLDA_StartRamp",
        LDA_module_fnLDA_StartRamp,
        METH_VARARGS,
        "Sets the ramp control mode to an LDA device"
    },  	
    {   
        "fnLDA_SaveSettings",
        LDA_module_fnLDA_SaveSettings,
        METH_VARARGS,
        "Sets the LDA save settings configuration"
    },  
    {   
        "fnLDA_perror",
        LDA_module_fnLDA_perror,
        METH_VARARGS,
        "Converts an LDA library error to a string"
    },  
    {   
        "fnLDA_LibVersion",
        LDA_module_fnLDA_LibVersion,
        METH_NOARGS,
        "Returns the LDA library version"
    },  
    {   
        "WrapperVersion",
        LDA_module_WrapperVersion,
        METH_NOARGS,
        "Returns the LDA library wrapper version"
    },  
    {NULL, NULL, 0, NULL}
};


//Module definition
//The arguments of this structure tell Python what to call your extension,
//what it's methods are and where to look for it's method definitions
static struct PyModuleDef LDA_module_definition = { 
    PyModuleDef_HEAD_INIT,
    "LDA_module",
    "A Python module for managing the Vaunix LDA series RF Attenuators.",
    -1, 
    LDA_module_methods
};

//Module initialization
//Python calls this function when importing your extension. It is important
//that this function is named PyInit_[[your_module_name]] exactly, and matches
//the name keyword argument in setup.py's setup() call.
PyMODINIT_FUNC PyInit_LDA_module(void)
{
    Py_Initialize();

    return PyModule_Create(&LDA_module_definition);
}

